/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.block.entity;

import java.util.Iterator;
import me.jddev0.ep.block.entity.EPBlockEntities;
import me.jddev0.ep.block.entity.base.FluidStorageSingleTankMethods;
import me.jddev0.ep.block.entity.base.MenuFluidStorageBlockEntity;
import me.jddev0.ep.config.ModConfigs;
import me.jddev0.ep.fluid.SimpleFluidStorage;
import me.jddev0.ep.inventory.CombinedContainerData;
import me.jddev0.ep.inventory.data.ProgressValueContainerData;
import me.jddev0.ep.screen.DrainMenu;
import me.jddev0.ep.util.FluidUtils;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.CauldronFluidContent;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DrainBlockEntity
extends MenuFluidStorageBlockEntity<SimpleFluidStorage> {
    private int progress;
    private int maxProgress = ModConfigs.COMMON_DRAIN_DRAIN_DURATION.getValue();

    public DrainBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(EPBlockEntities.DRAIN_ENTITY, blockPos, blockState, "drain", FluidStorageSingleTankMethods.INSTANCE, FluidUtils.convertMilliBucketsToDroplets(ModConfigs.COMMON_DRAIN_FLUID_TANK_CAPACITY.getValue() * 1000L));
    }

    @Override
    protected SimpleFluidStorage initFluidStorage() {
        return new SimpleFluidStorage(this.baseTankCapacity){

            protected void onFinalCommit() {
                DrainBlockEntity.this.method_5431();
                DrainBlockEntity.this.syncFluidToPlayers(32);
            }
        };
    }

    @Override
    protected class_3913 initContainerData() {
        return new CombinedContainerData(new ProgressValueContainerData(() -> this.progress, value -> {
            this.progress = value;
        }), new ProgressValueContainerData(() -> this.maxProgress, value -> {
            this.maxProgress = value;
        }));
    }

    @Nullable
    public class_1703 createMenu(int id, class_1661 inventory, class_1657 player) {
        this.syncFluidToPlayer(player);
        return new DrainMenu(id, this, inventory, this.data);
    }

    public int getRedstoneOutput() {
        return FluidUtils.getRedstoneSignalFromFluidHandler((Storage<FluidVariant>)this.fluidStorage);
    }

    @Override
    protected void method_11007(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10566("drain.progress", (class_2520)class_2497.method_23247((int)this.progress));
    }

    @Override
    protected void method_11014(@NotNull class_2487 nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.progress = nbt.method_10550("drain.progress");
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 state, DrainBlockEntity blockEntity) {
        if (level.method_8608()) {
            return;
        }
        if (DrainBlockEntity.hasRecipe(blockEntity)) {
            if (blockEntity.progress < 0 || blockEntity.maxProgress < 0) {
                blockEntity.resetProgress(blockPos, state);
                DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
                return;
            }
            if (blockEntity.progress < blockEntity.maxProgress) {
                ++blockEntity.progress;
            }
            if (blockEntity.progress >= blockEntity.maxProgress) {
                class_2338 aboveBlockPos = blockPos.method_10084();
                class_2680 aboveBlockState = level.method_8320(aboveBlockPos);
                class_2248 class_22482 = aboveBlockState.method_26204();
                if (class_22482 instanceof class_2263) {
                    class_2263 aboveBlock = (class_2263)class_22482;
                    class_1799 bucketItemStack = aboveBlock.method_9700(null, (class_1936)level, aboveBlockPos, aboveBlockState);
                    if (!bucketItemStack.method_7960()) {
                        Iterator iterator;
                        level.method_33596(null, (class_6880)class_5712.field_28167, aboveBlockPos);
                        Storage fluidStorage = (Storage)FluidStorage.ITEM.find(bucketItemStack, (Object)ContainerItemContext.withConstant((class_1799)bucketItemStack));
                        if (fluidStorage != null && (iterator = fluidStorage.iterator()).hasNext()) {
                            FluidVariant fluidVariant;
                            StorageView fluidView = (StorageView)iterator.next();
                            if (!iterator.hasNext() && !(fluidVariant = (FluidVariant)fluidView.getResource()).isBlank()) {
                                try (Transaction transaction = Transaction.openOuter();){
                                    ((SimpleFluidStorage)blockEntity.fluidStorage).insert((TransferVariant)fluidVariant, fluidView.getAmount(), (TransactionContext)transaction);
                                    transaction.commit();
                                }
                            }
                        }
                    }
                } else {
                    class_3611 cauldronFluid;
                    CauldronFluidContent cauldronFluidContent = CauldronFluidContent.getForBlock((class_2248)aboveBlockState.method_26204());
                    if (cauldronFluidContent != null && (cauldronFluid = cauldronFluidContent.fluid) != class_3612.field_15906 && (((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty() || ((SimpleFluidStorage)blockEntity.fluidStorage).getFluid().getFluid() == cauldronFluid)) {
                        long cauldronAmountPerLevel = cauldronFluidContent.amountPerLevel;
                        class_2758 cauldronLevelProp = cauldronFluidContent.levelProperty;
                        long amountInsertable = ((SimpleFluidStorage)blockEntity.fluidStorage).capacity - ((SimpleFluidStorage)blockEntity.fluidStorage).amount;
                        long cauldronAmount = cauldronLevelProp != null && aboveBlockState.method_28498((class_2769)cauldronLevelProp) ? cauldronAmountPerLevel * (long)((Integer)aboveBlockState.method_11654((class_2769)cauldronLevelProp)).intValue() : cauldronAmountPerLevel;
                        if (cauldronAmount > 0L && cauldronAmount <= amountInsertable) {
                            long inserted;
                            try (Transaction transaction = Transaction.openOuter();){
                                inserted = ((SimpleFluidStorage)blockEntity.fluidStorage).insert((TransferVariant)FluidVariant.of((class_3611)cauldronFluid), cauldronAmount, (TransactionContext)transaction);
                                if (inserted == cauldronAmount) {
                                    transaction.commit();
                                }
                            }
                            if (inserted == cauldronAmount) {
                                level.method_8652(aboveBlockPos, class_2246.field_10593.method_9564(), 3);
                            }
                        }
                    }
                }
                blockEntity.resetProgress(blockPos, state);
            }
            DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        } else {
            blockEntity.resetProgress(blockPos, state);
            DrainBlockEntity.method_31663((class_1937)level, (class_2338)blockPos, (class_2680)state);
        }
    }

    private void resetProgress(class_2338 blockPos, class_2680 state) {
        this.progress = 0;
    }

    private static boolean hasRecipe(DrainBlockEntity blockEntity) {
        class_3610 fluidState;
        class_2338 blockPos;
        class_2338 aboveBlockPos;
        class_1937 level = blockEntity.method_10997();
        class_2680 aboveBlockState = level.method_8320(aboveBlockPos = (blockPos = blockEntity.method_11016()).method_10084());
        if (aboveBlockState.method_26204() instanceof class_2263 && !(fluidState = level.method_8316(aboveBlockPos)).method_15769()) {
            try (Transaction transaction = Transaction.openOuter();){
                boolean bl = ((SimpleFluidStorage)blockEntity.fluidStorage).insert((TransferVariant)FluidVariant.of((class_3611)fluidState.method_15772()), 81000L, (TransactionContext)transaction) == 81000L;
                return bl;
            }
        }
        CauldronFluidContent cauldronFluidContent = CauldronFluidContent.getForBlock((class_2248)aboveBlockState.method_26204());
        if (cauldronFluidContent == null) {
            return false;
        }
        class_3611 cauldronFluid = cauldronFluidContent.fluid;
        if (cauldronFluid == class_3612.field_15906 || !((SimpleFluidStorage)blockEntity.fluidStorage).isEmpty() && ((SimpleFluidStorage)blockEntity.fluidStorage).getFluid().getFluid() != cauldronFluid) {
            return false;
        }
        long cauldronAmountPerLevel = cauldronFluidContent.amountPerLevel;
        class_2758 cauldronLevelProp = cauldronFluidContent.levelProperty;
        long amountInsertable = ((SimpleFluidStorage)blockEntity.fluidStorage).capacity - ((SimpleFluidStorage)blockEntity.fluidStorage).amount;
        long cauldronAmount = cauldronLevelProp != null && aboveBlockState.method_28498((class_2769)cauldronLevelProp) ? cauldronAmountPerLevel * (long)((Integer)aboveBlockState.method_11654((class_2769)cauldronLevelProp)).intValue() : cauldronAmountPerLevel;
        return cauldronAmount > 0L && cauldronAmount <= amountInsertable;
    }
}

